//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : BH67F2265WConfig.c
// Description: BH67F2265暫存器快速設定
//Targer Board: 
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________
#ifndef _MCUCONFIG_H_
#define _MCUCONFIG_H_


#define Debug
//定義 IAR1 方便 bit 操作
static volatile __byte_type  SFR_iar1 __attribute__((at(0x02)));

//設置初始化 rambank 個數
#define RamBankSectorSum	4
#define LU8C_HALT_TIME		240

//__________________________________________________________________//
//					-----ISR VECTOR Defination------;
//中斷入口地址
#define	START_VECTOR			0x000		//主程序
#define	INT0_VECTOR				0x004		//Intrrupt 0
#define	INT1_VECTOR				0x008		//Intrrupt 1
#define ADC_VECTOR				0x0C		//ADC 中斷
#define	MF0_VECTOR				0x0010		//復合中斷 0
#define	MF1_VECTOR				0x0014		//復合中斷 1
#define TB0_VECTOR				0x018		//TB0中斷 
#define TB1_VECTOR				0x01c		//TB1中斷 
#define SIM_VECTOR				0x020		//SIM中斷 
#define UART_VECTOR				0x024		//UART中斷 
#define EEPROM_VECTOR			0x028		//SPIA中斷 
#define SCF_VECTOR				0x02C		//SCF中斷 




#endif
